﻿using System;
using System.Linq;
using Smartling.Connector.Extensions;
using Smartling.Connector.Security;
using Smartling.Connector.Translation;
using Smartling.Connector.Translation.Profile;

namespace Smartling.Connector.sitecore_modules.Shell.Smartling.Connector
{
  public partial class TranslationAudit : System.Web.UI.Page
  {
    protected void Page_Load(object sender, EventArgs e)
    {
      if (SecurityManager.AccessAllowed())
      {
        LoadFilters();
      }
    }

    private void LoadFilters()
    {
      var profiles = new ProfileService().GetAllProfiles();
      foreach (var profile in profiles)
      {
        Profiles.Text += string.Format("<option value=\"{0}\">{1}</option>", profile.Name, profile.Name);
      }

      var languages = new ProfileService().GetAllSupportedLocales();
      foreach (var language in languages.GroupBy(x => x.Name).Select(g => g.First()))
      {
        LanguageOptions.Text += string.Format("<option value=\"{0}\">{1}</option>", language.Name, language.DisplayName);
      }

      EventTypes.Text += string.Format("<option value=\"{0}\">{1}</option>", ModuleConstants.Audit.Download, ModuleConstants.Audit.Download.CapitalizeFirstLetter());
      EventTypes.Text += string.Format("<option value=\"{0}\">{1}</option>", ModuleConstants.Audit.Upload, ModuleConstants.Audit.Upload.CapitalizeFirstLetter());
      EventTypes.Text += string.Format("<option value=\"{0}\">{1}</option>", ModuleConstants.Audit.Lock, ModuleConstants.Audit.Lock.CapitalizeFirstLetter());
      EventTypes.Text += string.Format("<option value=\"{0}\">{1}</option>", ModuleConstants.Audit.Unlock, ModuleConstants.Audit.Unlock.CapitalizeFirstLetter());
      EventTypes.Text += string.Format("<option value=\"{0}\">{1}</option>", ModuleConstants.Audit.Cancel, ModuleConstants.Audit.Cancel.CapitalizeFirstLetter());
      EventTypes.Text += string.Format("<option value=\"{0}\">{1}</option>", ModuleConstants.Audit.ProfileUpdated, ModuleConstants.Audit.ProfileUpdated.CapitalizeFirstLetter().ReplaceUnderscoreWithSpace());
      EventTypes.Text += string.Format("<option value=\"{0}\">{1}</option>", ModuleConstants.Audit.ProfileDeleted, ModuleConstants.Audit.ProfileDeleted.CapitalizeFirstLetter().ReplaceUnderscoreWithSpace());
    }
  }
}